/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;

public class ConcatenateGraphTokenFilterFactory
extends AbstractTokenFilterFactory {
    public static final String DEFAULT_TOKEN_SEPARATOR = " ";
    public static final int DEFAULT_MAX_GRAPH_EXPANSIONS = 100;
    public static final boolean DEFAULT_PRESERVE_POSITION_INCREMENTS = false;
    private final Character tokenSeparator;
    private final int maxGraphExpansions;
    private final boolean preservePositionIncrements;

    ConcatenateGraphTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String separator = settings.get("token_separator", DEFAULT_TOKEN_SEPARATOR);
        if (separator.length() > 1) {
            throw new IllegalArgumentException("token_separator must be either empty or a single character");
        }
        this.tokenSeparator = separator.length() == 0 ? null : Character.valueOf(separator.charAt(0));
        this.maxGraphExpansions = settings.getAsInt("max_graph_expansions", Integer.valueOf(100));
        this.preservePositionIncrements = settings.getAsBoolean("preserve_position_increments", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ConcatenateGraphFilter(tokenStream, this.tokenSeparator, this.preservePositionIncrements, this.maxGraphExpansions);
    }
}

