/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.DelimitedTermFrequencyTokenFilter;

public class DelimitedTermFrequencyTokenFilterFactory
extends AbstractTokenFilterFactory {
    public static final char DEFAULT_DELIMITER = '|';
    private static final String DELIMITER = "delimiter";
    private final char delimiter;

    DelimitedTermFrequencyTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.delimiter = DelimitedTermFrequencyTokenFilterFactory.parseDelimiter(settings);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new DelimitedTermFrequencyTokenFilter(tokenStream, this.delimiter);
    }

    private static char parseDelimiter(Settings settings) {
        String delimiter = settings.get(DELIMITER);
        if (delimiter == null) {
            return '|';
        }
        if (delimiter.length() == 1) {
            return delimiter.charAt(0);
        }
        throw new IllegalArgumentException("Setting [delimiter] must be a single, non-null character. [" + delimiter + "] was provided.");
    }
}

