/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.lucenia.analysis.common.AbstractCompoundWordTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final HyphenationTree hyphenationTree;

    HyphenationCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, env, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new IllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        Path hyphenationPatternsFile = Analysis.resolveAnalyzerPath((Environment)env, (String)hyphenationPatternsPath);
        try {
            InputStream in = Files.newInputStream(hyphenationPatternsFile, new OpenOption[0]);
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)new InputSource(in));
        }
        catch (Exception e) {
            LogManager.getLogger(HyphenationCompoundWordTokenFilterFactory.class).error("Exception while reading hyphenation_patterns_path ", (Throwable)e);
            throw new IllegalArgumentException("Exception while reading hyphenation_patterns_path.");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new HyphenationCompoundWordTokenFilter(tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

