/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;

public class KeywordMarkerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keywordLookup;
    private final Pattern keywordPattern;

    KeywordMarkerTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        boolean ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        String patternString = settings.get("keywords_pattern");
        if (patternString != null) {
            if (settings.get("keywords") != null || settings.get("keywords_path") != null) {
                throw new IllegalArgumentException("cannot specify both `keywords_pattern` and `keywords` or `keywords_path`");
            }
            this.keywordPattern = Pattern.compile(patternString);
            this.keywordLookup = null;
        } else {
            CharArraySet rules = Analysis.getWordSet((Environment)env, (Settings)settings, (String)"keywords");
            if (rules == null) {
                throw new IllegalArgumentException("keyword filter requires either `keywords`, `keywords_path`, or `keywords_pattern` to be configured");
            }
            this.keywordLookup = new CharArraySet((Collection)rules, ignoreCase);
            this.keywordPattern = null;
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.keywordPattern != null) {
            return new PatternKeywordMarkerFilter(tokenStream, this.keywordPattern);
        }
        return new SetKeywordMarkerFilter(tokenStream, this.keywordLookup);
    }
}

