/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.lucenia.analysis.common.PatternAnalyzer;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.AbstractIndexAnalyzerProvider;
import io.skylite.core.settings.Settings;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;

public class PatternAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final PatternAnalyzer analyzer;

    PatternAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet defaultStopwords = CharArraySet.EMPTY_SET;
        boolean lowercase = settings.getAsBoolean("lowercase", Boolean.valueOf(true));
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)defaultStopwords);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("Analyzer [" + name + "] of type pattern must have a `pattern` set");
        }
        Pattern pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.analyzer = new PatternAnalyzer(pattern, lowercase, stopWords);
    }

    public PatternAnalyzer get() {
        return this.analyzer;
    }
}

