/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;

public class TruncateTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int length;

    TruncateTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.length = settings.getAsInt("length", Integer.valueOf(-1));
        if (this.length <= 0) {
            throw new IllegalArgumentException("length parameter must be provided");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new TruncateTokenFilter(tokenStream, this.length);
    }
}

