#!/bin/bash

echo "**************************************************************************" >&2
echo "** This tool will be deprecated in the next major release of Lucenia **" >&2
echo "** https://github.com/opensearch-project/security/issues/1755           **" >&2
echo "**************************************************************************" >&2

SCRIPT_PATH="${BASH_SOURCE[0]}"
if ! [ -x "$(command -v realpath)" ]; then
    if [ -L "$SCRIPT_PATH" ]; then

        [ -x "$(command -v readlink)" ] || { echo "Not able to resolve symlink. Install realpath or readlink.";exit 1; }

        # try readlink (-f not needed because we know its a symlink)
        DIR="$( cd "$( dirname $(readlink "$SCRIPT_PATH") )" && pwd -P)"
    else
        DIR="$( cd "$( dirname "$SCRIPT_PATH" )" && pwd -P)"
    fi
else
    DIR="$( cd "$( dirname "$(realpath "$SCRIPT_PATH")" )" && pwd -P)"
fi

BIN_PATH="java"

# now set the path to java: first LUCENIA_JAVA_HOME, then JAVA_HOME
if [ ! -z "$LUCENIA_JAVA_HOME" ]; then
    BIN_PATH="$LUCENIA_JAVA_HOME/bin/java"
elif [ ! -z "$JAVA_HOME" ]; then
    BIN_PATH="$JAVA_HOME/bin/java"
else
    echo "WARNING: nor LUCENIA_JAVA_HOME nor JAVA_HOME is set, will use $(which $BIN_PATH)"
fi


"$BIN_PATH" $JAVA_OPTS -cp "$DIR/../../opendistro_security_ssl/*:$DIR/../*:$DIR/../deps/*:$DIR/../../../lib/*" io.lucenia.security.tools.Hasher "$@"
